#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis -
# Section: Additional File Description Analysis of Data
# 2 Summary of Variability and Assessment Results
# 2018 TUDelft
# Output file "variability_aftercomputation.txt" will be created 
#
# required datafiles
# - 89_imputed.sav
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
d89=read.spss("Acceptance research/smartpls scripts, data & results/Data/89_imputed.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# direct output to a file 
sink("Acceptance research/r results/variability_aftercomputation.txt", append=FALSE, split=FALSE)

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app 
# Performance Expectancy:
# PE1	The SleepCare app provides me information about sleep
# PE2	I feel relax assisting by the SleepCare app
# PE3	The SleepCare app helps me to sleep better
# PE4	The SleepCare app provides me clear insight about my sleep pattern
# PE5	The SleepCare app provides me enough controls over my own intervention
# PE6	Using the SleepCare app, I can do the exercises independently and stay anonymous 
# PE7	The SleepCare app fits my personality
#
# Effort Expectancy:
# EE1	The use of the SleepCare app gives me no ambiguities
# EE2	The SleepCare app is easy to use
# EE3	Learning to work with the SleepCare app is easy for me
# EE4	Utilizing the app gives me little trouble
# EE5_R	Using the SleepCare app is too complicated so I find it hard to understand
# EE6	The app fits in with my daily life
#
# Social Influence
# SI1	I think that my friends would recommend me to use the SleepCare app
# SI2	I think that my family would think I should use the SleepCare app
# SI3	I think that the people in my work environment would encourage me to use the SleepCare app
# SI4	I think that other people with sleep problems would encourage me to use the SleepCare app
# SI5_R	I think that my surrounding would think negatively to a person who use the SleepCare app 
#
# Self_Efficacy
# SE1	I can work well with the SleepCare app without help from others
# SE2	I will be able to use the SleepCare app as long as nothing abnormal happens
# SE3	I can work independently with the SleepCare app
# SE4	I am sure that I'm using the SleepCare app in a good way
#
# Trust
# TR1	I trust the information that SleepCare app provides me with
# TR2_R	I think the SleepCare app will put my privacy at risk
# TR3	I am confident that the SleepCare app will work well
#
# Hedonic Motivation
# HM1	Using the SleepCare app is a good idea
# HM2_R	I hate using the SleepCare app
# HM3	I find that using the SleepCare app is fun
# HM4	I find that using the SleepCare app is interesting
# HM5	The SleepCare app gives me the feeling that my problem is taken seriously
# HM6	The approach of the SleepCare app makes me feel safe
# HM7_R	I feel apprehensive when using the SleepCare app
#
# Anxiety
# AN1_R	I'm worried about using the app
# AN2_R	I'm sometime afraid of losing information if I press a wrong button 
# AN3_R	I'm afraid to make mistakes in the SleepCare app that I cannot turn them back
# AN4_R	I feel somewhat intimidated by the SleepCare app 
#
# Behavioral Intention
# BI1	I will definitely finish the training
# BI2	I will definitely fill in the sleep diary everyday
# BI3	I will definitely do the relaxation exercise everyday
# BI4	I will certainly stay compliant to the bedtimes that I have agreed with the coach
# BI5	I am going to follow up on the sleep tips
# BI6	I am going to fill in my sleep_times in the sleep diary as well as possible
# BI7	I am going to take the time to do the relaxation exercise everyday 
#
# Facilitating Condition
# FC1	I have enough knowledge necessary for using the SleepCare app
# FC2	My mobile phone works perfectly for running the SleepCare app
# FC3	Where necessary, the SleepCare team will help me to use the SleepCare app
# FC4	Where necessary, my friends and/or family will help me to use the SleepCare app
#
# User Behavioral Data:
# SD_DO	The number of days a participant entered the sleep diary
# CONV_DO	The number of completed conversations
# RE_DO	The number of days the participant completed one or more relaxation exercise

cat("\n VARIABILITY INDICATORS HMTER IMPUTATION (n=89)\n\n")
cat("     Performance Expectancy \n")
cat("       PE1:\n")
cat("          Mean: ")
mean(d89[,"PE1"])
cat("          Variance: ")
var(d89[,"PE1"])
cat("          SD:")
sd(d89[,"PE1"])
cat("          Range:")
range(d89[,"PE1"])
cat("          IQR:")
IQR(d89[,"PE1"])
cat("       PE2:\n")
cat("          Mean: ")
mean(d89[,"PE2"])
cat("          Variance: ")
var(d89[,"PE2"])
cat("          SD:")
sd(d89[,"PE2"])
cat("          Range:")
range(d89[,"PE2"])
cat("          IQR:")
IQR(d89[,"PE2"])
cat("       PE3:\n")
cat("          Mean: ")
mean(d89[,"PE3"])
cat("          Variance: ")
var(d89[,"PE3"])
cat("          SD:")
sd(d89[,"PE3"])
cat("          Range:")
range(d89[,"PE3"])
cat("          IQR:")
IQR(d89[,"PE3"])
cat("       PE4:\n")
cat("          Mean: ")
mean(d89[,"PE4"])
cat("          Variance: ")
var(d89[,"PE4"])
cat("          SD:")
sd(d89[,"PE4"])
cat("          Range:")
range(d89[,"PE4"])
cat("          IQR:")
IQR(d89[,"PE4"])
cat("       PE5:\n")
cat("          Mean: ")
mean(d89[,"PE5"])
cat("          Variance: ")
var(d89[,"PE5"])
cat("          SD:")
sd(d89[,"PE5"])
cat("          Range:")
range(d89[,"PE5"])
cat("          IQR:")
IQR(d89[,"PE5"])
cat("       PE6:\n")
cat("          Mean: ")
mean(d89[,"PE6"])
cat("          Variance: ")
var(d89[,"PE6"])
cat("          SD:")
sd(d89[,"PE6"])
cat("          Range:")
range(d89[,"PE6"])
cat("          IQR:")
IQR(d89[,"PE6"])
cat("       PE7:\n")
cat("          Mean: ")
mean(d89[,"PE7"])
cat("          Variance: ")
var(d89[,"PE7"])
cat("          SD:")
sd(d89[,"PE7"])
cat("          Range:")
range(d89[,"PE7"])
cat("          IQR:")
IQR(d89[,"PE7"])

cat("     Effort Expectancy \n")
cat("       EE1:\n")
cat("          Mean: ")
mean(d89[,"EE1"])
cat("          Variance: ")
var(d89[,"EE1"])
cat("          SD:")
sd(d89[,"EE1"])
cat("          Range:")
range(d89[,"EE1"])
cat("          IQR:")
IQR(d89[,"EE1"])
cat("       EE2:\n")
cat("          Mean: ")
mean(d89[,"EE2"])
cat("          Variance: ")
var(d89[,"EE2"])
cat("          SD:")
sd(d89[,"EE2"])
cat("          Range:")
range(d89[,"EE2"])
cat("          IQR:")
IQR(d89[,"EE2"])
cat("       EE3:\n")
cat("          Mean: ")
mean(d89[,"EE3"])
cat("          Variance: ")
var(d89[,"EE3"])
cat("          SD:")
sd(d89[,"EE3"])
cat("          Range:")
range(d89[,"EE3"])
cat("          IQR:")
IQR(d89[,"EE3"])
cat("       EE4:\n")
cat("          Mean: ")
mean(d89[,"EE4"])
cat("          Variance: ")
var(d89[,"EE4"])
cat("          SD:")
sd(d89[,"EE4"])
cat("          Range:")
range(d89[,"EE4"])
cat("          IQR:")
IQR(d89[,"EE4"])
cat("       EE5_R:\n")
cat("          Mean: ")
mean(d89[,"EE5_R"])
cat("          Variance: ")
var(d89[,"EE5_R"])
cat("          SD:")
sd(d89[,"EE5_R"])
cat("          Range:")
range(d89[,"EE5_R"])
cat("          IQR:")
IQR(d89[,"EE5_R"])
cat("       EE6:\n")
cat("          Mean: ")
mean(d89[,"EE6"])
cat("          Variance: ")
var(d89[,"EE6"])
cat("          SD:")
sd(d89[,"EE6"])
cat("          Range:")
range(d89[,"EE6"])
cat("          IQR:")
IQR(d89[,"EE6"])

cat("     Social Influence \n")
cat("       SI1:\n")
cat("          Mean: ")
mean(d89[,"SI1"])
cat("          Variance: ")
var(d89[,"SI1"])
cat("          SD:")
sd(d89[,"SI1"])
cat("          Range:")
range(d89[,"SI1"])
cat("          IQR:")
IQR(d89[,"SI1"])
cat("       SI2:\n")
cat("          Mean: ")
mean(d89[,"SI2"])
cat("          Variance: ")
var(d89[,"SI2"])
cat("          SD:")
sd(d89[,"SI2"])
cat("          Range:")
range(d89[,"SI2"])
cat("          IQR:")
IQR(d89[,"SI2"])
cat("       SI3:\n")
cat("          Mean: ")
mean(d89[,"SI3"])
cat("          Variance: ")
var(d89[,"SI3"])
cat("          SD:")
sd(d89[,"SI3"])
cat("          Range:")
range(d89[,"SI3"])
cat("          IQR:")
IQR(d89[,"SI3"])
cat("       SI4:\n")
cat("          Mean: ")
mean(d89[,"SI4"])
cat("          Variance: ")
var(d89[,"SI4"])
cat("          SD:")
sd(d89[,"SI4"])
cat("          Range:")
range(d89[,"SI4"])
cat("          IQR:")
IQR(d89[,"SI4"])
cat("       SI5_R:\n")
cat("          Mean: ")
mean(d89[,"SI5_R"])
cat("          Variance: ")
var(d89[,"SI5_R"])
cat("          SD:")
sd(d89[,"SI5_R"])
cat("          Range:")
range(d89[,"SI5_R"])
cat("          IQR:")
IQR(d89[,"SI5_R"])

cat("     Self-Efficacy \n")
cat("       SE1:\n")
cat("          Mean: ")
mean(d89[,"SE1"])
cat("          Variance: ")
var(d89[,"SE1"])
cat("          SD:")
sd(d89[,"SE1"])
cat("          Range:")
range(d89[,"SE1"])
cat("          IQR:")
IQR(d89[,"SE1"])
cat("       SE2:\n")
cat("          Mean: ")
mean(d89[,"SE2"])
cat("          Variance: ")
var(d89[,"SE2"])
cat("          SD:")
sd(d89[,"SE2"])
cat("          Range:")
range(d89[,"SE2"])
cat("          IQR:")
IQR(d89[,"SE2"])
cat("       SE3:\n")
cat("          Mean: ")
mean(d89[,"SE3"])
cat("          Variance: ")
var(d89[,"SE3"])
cat("          SD:")
sd(d89[,"SE3"])
cat("          Range:")
range(d89[,"SE3"])
cat("          IQR:")
IQR(d89[,"SE3"])
cat("       SE4:\n")
cat("          Mean: ")
mean(d89[,"SE4"])
cat("          Variance: ")
var(d89[,"SE4"])
cat("          SD:")
sd(d89[,"SE4"])
cat("          Range:")
range(d89[,"SE4"])
cat("          IQR:")
IQR(d89[,"SE4"])

cat("     Trust \n")
cat("       TR1:\n")
cat("          Mean: ")
mean(d89[,"TR1"])
cat("          Variance: ")
var(d89[,"TR1"])
cat("          SD:")
sd(d89[,"TR1"])
cat("          Range:")
range(d89[,"TR1"])
cat("          IQR:")
IQR(d89[,"TR1"])
cat("       TR2_R:\n")
cat("          Mean: ")
mean(d89[,"TR2_R"])
cat("          Variance: ")
var(d89[,"TR2_R"])
cat("          SD:")
sd(d89[,"TR2_R"])
cat("          Range:")
range(d89[,"TR2_R"])
cat("          IQR:")
IQR(d89[,"TR2_R"])
cat("       TR3:\n")
cat("          Mean: ")
mean(d89[,"TR3"])
cat("          Variance: ")
var(d89[,"TR3"])
cat("          SD:")
sd(d89[,"TR3"])
cat("          Range:")
range(d89[,"TR3"])
cat("          IQR:")
IQR(d89[,"TR3"])

cat("     Hedonic Motivation \n")
cat("       HM1:\n")
cat("          Mean: ")
mean(d89[,"HM1"])
cat("          Variance: ")
var(d89[,"HM1"])
cat("          SD:")
sd(d89[,"HM1"])
cat("          Range:")
range(d89[,"HM1"])
cat("          IQR:")
IQR(d89[,"HM1"])
cat("       HM2_R:\n")
cat("          Mean: ")
mean(d89[,"HM2_R"])
cat("          Variance: ")
var(d89[,"HM2_R"])
cat("          SD:")
sd(d89[,"HM2_R"])
cat("          Range:")
range(d89[,"HM2_R"])
cat("          IQR:")
IQR(d89[,"HM2_R"])
cat("       HM3:\n")
cat("          Mean: ")
mean(d89[,"HM3"])
cat("          Variance: ")
var(d89[,"HM3"])
cat("          SD:")
sd(d89[,"HM3"])
cat("          Range:")
range(d89[,"HM3"])
cat("          IQR:")
IQR(d89[,"HM3"])
cat("       HM4:\n")
cat("          Mean: ")
mean(d89[,"HM4"])
cat("          Variance: ")
var(d89[,"HM4"])
cat("          SD:")
sd(d89[,"HM4"])
cat("          Range:")
range(d89[,"HM4"])
cat("          IQR:")
IQR(d89[,"HM4"])
cat("       HM5:\n")
cat("          Mean: ")
mean(d89[,"HM5"])
cat("          Variance: ")
var(d89[,"HM5"])
cat("          SD:")
sd(d89[,"HM5"])
cat("          Range:")
range(d89[,"HM5"])
cat("          IQR:")
IQR(d89[,"HM5"])
cat("       HM6:\n")
cat("          Mean: ")
mean(d89[,"HM6"])
cat("          Variance: ")
var(d89[,"HM6"])
cat("          SD:")
sd(d89[,"HM6"])
cat("          Range:")
range(d89[,"HM6"])
cat("          IQR:")
IQR(d89[,"HM6"])
cat("       HM7_R:\n")
cat("          Mean: ")
mean(d89[,"HM7_R"])
cat("          Variance: ")
var(d89[,"HM7_R"])
cat("          SD:")
sd(d89[,"HM7_R"])
cat("          Range:")
range(d89[,"HM7_R"])
cat("          IQR:")
IQR(d89[,"HM7_R"])

cat("     Anxiety \n")
cat("       AN1_R:\n")
cat("          Mean: ")
mean(d89[,"AN1_R"])
cat("          Variance: ")
var(d89[,"AN1_R"])
cat("          SD:")
sd(d89[,"AN1_R"])
cat("          Range:")
range(d89[,"AN1_R"])
cat("          IQR:")
IQR(d89[,"AN1_R"])
cat("       AN2_R:\n")
cat("          Mean: ")
mean(d89[,"AN2_R"])
cat("          Variance: ")
var(d89[,"AN2_R"])
cat("          SD:")
sd(d89[,"AN2_R"])
cat("          Range:")
range(d89[,"AN2_R"])
cat("          IQR:")
IQR(d89[,"AN2_R"])
cat("       AN3_R:\n")
cat("          Mean: ")
mean(d89[,"AN3_R"])
cat("          Variance: ")
var(d89[,"AN3_R"])
cat("          SD:")
sd(d89[,"AN3_R"])
cat("          Range:")
range(d89[,"AN3_R"])
cat("          IQR:")
IQR(d89[,"AN3_R"])
cat("       AN4_R:\n")
cat("          Mean: ")
mean(d89[,"AN4_R"])
cat("          Variance: ")
var(d89[,"AN4_R"])
cat("          SD:")
sd(d89[,"AN4_R"])
cat("          Range:")
range(d89[,"AN4_R"])
cat("          IQR:")
IQR(d89[,"AN4_R"])

cat("     Facilitating Condition \n")
cat("       FC1:\n")
cat("          Mean: ")
mean(d89[,"FC1"])
cat("          Variance: ")
var(d89[,"FC1"])
cat("          SD:")
sd(d89[,"FC1"])
cat("          Range:")
range(d89[,"FC1"])
cat("          IQR:")
IQR(d89[,"FC1"])
cat("       FC2:\n")
cat("          Mean: ")
mean(d89[,"FC2"])
cat("          Variance: ")
var(d89[,"FC2"])
cat("          SD:")
sd(d89[,"FC2"])
cat("          Range:")
range(d89[,"FC2"])
cat("          IQR:")
IQR(d89[,"FC2"])
cat("       FC3:\n")
cat("          Mean: ")
mean(d89[,"FC3"])
cat("          Variance: ")
var(d89[,"FC3"])
cat("          SD:")
sd(d89[,"FC3"])
cat("          Range:")
range(d89[,"FC3"])
cat("          IQR:")
IQR(d89[,"FC3"])
cat("       FC4:\n")
cat("          Mean: ")
mean(d89[,"FC4"])
cat("          Variance: ")
var(d89[,"FC4"])
cat("          SD:")
sd(d89[,"FC4"])
cat("          Range:")
range(d89[,"FC4"])
cat("          IQR:")
IQR(d89[,"FC4"])

cat("     Behavioral Intention \n")
cat("       BI1:\n")
cat("          Mean: ")
mean(d89[,"BI1"])
cat("          Variance: ")
var(d89[,"BI1"])
cat("          SD:")
sd(d89[,"BI1"])
cat("          Range:")
range(d89[,"BI1"])
cat("          IQR:")
IQR(d89[,"BI1"])
cat("       BI2:\n")
cat("          Mean: ")
mean(d89[,"BI2"])
cat("          Variance: ")
var(d89[,"BI2"])
cat("          SD:")
sd(d89[,"BI2"])
cat("          Range:")
range(d89[,"BI2"])
cat("          IQR:")
IQR(d89[,"BI2"])
cat("       BI3:\n")
cat("          Mean: ")
mean(d89[,"BI3"])
cat("          Variance: ")
var(d89[,"BI3"])
cat("          SD:")
sd(d89[,"BI3"])
cat("          Range:")
range(d89[,"BI3"])
cat("          IQR:")
IQR(d89[,"BI3"])
cat("       BI4:\n")
cat("          Mean: ")
mean(d89[,"BI4"])
cat("          Variance: ")
var(d89[,"BI4"])
cat("          SD:")
sd(d89[,"BI4"])
cat("          Range:")
range(d89[,"BI4"])
cat("          IQR:")
IQR(d89[,"BI4"])
cat("       BI5:\n")
cat("          Mean: ")
mean(d89[,"BI5"])
cat("          Variance: ")
var(d89[,"BI5"])
cat("          SD:")
sd(d89[,"BI5"])
cat("          Range:")
range(d89[,"BI5"])
cat("          IQR:")
IQR(d89[,"BI5"])
cat("       BI6:\n")
cat("          Mean: ")
mean(d89[,"BI6"])
cat("          Variance: ")
var(d89[,"BI6"])
cat("          SD:")
sd(d89[,"BI6"])
cat("          Range:")
range(d89[,"BI6"])
cat("          IQR:")
IQR(d89[,"BI6"])
cat("       BI7:\n")
cat("          Mean: ")
mean(d89[,"BI7"])
cat("          Variance: ")
var(d89[,"BI7"])
cat("          SD:")
sd(d89[,"BI7"])
cat("          Range:")
range(d89[,"BI7"])
cat("          IQR:")
IQR(d89[,"BI7"])

cat("     Use Behavior \n")
cat("       SD_DO:\n")
cat("          Mean: ")
mean(d89[,"SD_DO"])
cat("          Variance: ")
var(d89[,"SD_DO"])
cat("          SD:")
sd(d89[,"SD_DO"])
cat("          Range:")
range(d89[,"SD_DO"])
cat("          IQR:")
IQR(d89[,"SD_DO"])
cat("       CONV_DO:\n")
cat("          Mean: ")
mean(d89[,"CONV_DO"])
cat("          Variance: ")
var(d89[,"CONV_DO"])
cat("          SD:")
SD(d89[,"CONV_DO"])
cat("          Range:")
range(d89[,"CONV_DO"])
cat("          IQR:")
IQR(d89[,"CONV_DO"])
cat("       RE_DO:\n")
cat("          Mean: ")
mean(d89[,"RE_DO"])
cat("          Variance: ")
var(d89[,"RE_DO"])
cat("          SD:")
SD(d89[,"RE_DO"])
cat("          Range:")
range(d89[,"RE_DO"])
cat("          IQR:")
IQR(d89[,"RE_DO"])

cat("\n\n################ End of Variability Indicators after imputation ################### \n")
######### stop redirecting output.
sink()